unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, FastFour;

type
  TFormMain = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    RadioGroupInitData: TRadioGroup;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    TrackBarLow: TTrackBar;
    TrackBarHigh: TTrackBar;
    TrackBarNoise: TTrackBar;
    ButtonReset: TButton;
    ButtonClose: TButton;
    PaintBoxCenter: TPaintBox;
    PaintBoxTop: TPaintBox;
    Panel4: TPanel;
    Label4: TLabel;
    Label5: TLabel;
    Panel5: TPanel;
    Label6: TLabel;
    Label7: TLabel;
    FastFourier1: TFastFourier;
    procedure ButtonCloseClick(Sender: TObject);
    procedure PaintBoxTopPaint(Sender: TObject);
    procedure PaintBoxCenterPaint(Sender: TObject);
    procedure TrackBarLowChange(Sender: TObject);
    procedure TrackBarHighChange(Sender: TObject);
    procedure TrackBarNoiseChange(Sender: TObject);
    procedure ButtonResetClick(Sender: TObject);
    procedure RadioGroupInitDataClick(Sender: TObject);
    procedure FastFourier1GetValue(Sender: TObject; Index: LongInt;
      ComplexPart: TComplexNumPart; var Value: Double);
    procedure FormCreate(Sender: TObject);
  private
    Randoms: array[1..8192] of Double;
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

procedure TFormMain.FormCreate(Sender: TObject);
var
  i: Integer;
  style: longint;
begin
  style := GetWindowLong(TrackBarLow.Handle,GWL_STYLE) and (not 32);
  SetWindowLong(TrackBarLow.Handle,GWL_STYLE,style);
  SetWindowLong(TrackBarHigh.Handle,GWL_STYLE,style);
  SetWindowLong(TrackBarNoise.Handle,GWL_STYLE,style);

  for i := 1 to 8192 do
    Randoms[i] := random-0.5;

  FastFourier1.DoFourier;
  FastFourier1.DoInverse;
  PaintBoxTop.Invalidate;
  PaintBoxCenter.Invalidate;
end;


procedure TFormMain.ButtonCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TFormMain.PaintBoxTopPaint(Sender: TObject);
var
  x,y,i: LongInt;
  w: Integer;
begin
  PaintBoxTop.Canvas.Brush.Color := clRed;
  x := PaintBoxTop.Width div FastFourier1.Length;
  w := x;
  for i := 1 to FastFourier1.Length div 2 do
    begin
      y := Round(PaintBoxTop.Height - PaintBoxTop.Height*0.9*FastFourier1.Spectrum[i]);
      PaintBoxTop.Canvas.Rectangle(x,y,x+w,PaintBoxTop.Height);
      x := x + w;
    end;

  PaintBoxTop.Canvas.Brush.Color := clYellow;
  x := PaintBoxTop.Width div FastFourier1.Length;
  for i := 1 to FastFourier1.Length div 2 do
    begin
      y := Round(PaintBoxTop.Height div 2 - PaintBoxTop.Height*0.9*FastFourier1.TransformedSpectrum[i]);
      PaintBoxTop.Canvas.Rectangle(x,y,x+w,PaintBoxTop.Height div 2);
      x := x + w;
    end;
end;

procedure TFormMain.PaintBoxCenterPaint(Sender: TObject);
var
  x,y,i: LongInt;
  value: Double;
begin
  PaintBoxCenter.Canvas.Pen.Color := clRed;
  FastFourier1GetValue(self,1,cpRe,Value);
  x := Round(PaintBoxCenter.Width/FastFourier1.Length);
  y := Round(PaintBoxCenter.Height/2 + PaintBoxCenter.Height/2*Value);
  PaintBoxCenter.Canvas.MoveTo(x,y);
  for i := 2 to FastFourier1.Length do
    begin
      FastFourier1GetValue(self,i,cpRe,value);
      x := Round(PaintBoxCenter.Width/FastFourier1.Length*i);
      y := Round(PaintBoxCenter.Height/2 + PaintBoxCenter.Height/2*Value);
      PaintBoxCenter.Canvas.LineTo(x,y);
    end;

  PaintBoxCenter.Canvas.Pen.Color := clYellow;
  x := Round(PaintBoxCenter.Width/FastFourier1.Length);
  y := Round(PaintBoxCenter.Height/2 + PaintBoxCenter.Height/2*FastFourier1.Inverse[1,cpRe]);
  PaintBoxCenter.Canvas.MoveTo(x,y);
  for i := 2 to FastFourier1.Length do
    begin
      x := Round(PaintBoxCenter.Width/FastFourier1.Length*i);
      y := Round(PaintBoxCenter.Height/2 + PaintBoxCenter.Height/2*FastFourier1.Inverse[i,cpRe]);
      PaintBoxCenter.Canvas.LineTo(x,y);
    end;
end;


procedure TFormMain.TrackBarLowChange(Sender: TObject);
begin
  FastFourier1.LowCut := TrackBarLow.Position;
  FastFourier1.DoInverse;
  PaintBoxTop.Invalidate;
  PaintBoxCenter.Invalidate;
end;

procedure TFormMain.TrackBarHighChange(Sender: TObject);
begin
  FastFourier1.HighCut := TrackBarHigh.Position;
  FastFourier1.DoInverse;
  PaintBoxTop.Invalidate;
  PaintBoxCenter.Invalidate;
end;

procedure TFormMain.TrackBarNoiseChange(Sender: TObject);
begin
  FastFourier1.Noise := TrackBarNoise.Position;
  FastFourier1.DoInverse;
  PaintBoxTop.Invalidate;
  PaintBoxCenter.Invalidate;
end;


procedure TFormMain.ButtonResetClick(Sender: TObject);
var
  i: Integer;
begin
  for i := 1 to 8192 do
    Randoms[i] := random-0.5;

  FastFourier1.DoFourier;
  FastFourier1.DoInverse;
  PaintBoxTop.Invalidate;
  PaintBoxCenter.Invalidate;
end;

procedure TFormMain.RadioGroupInitDataClick(Sender: TObject);
begin
  FastFourier1.DoFourier;
  FastFourier1.DoInverse;
  PaintBoxTop.Invalidate;
  PaintBoxCenter.Invalidate;
end;

procedure TFormMain.FastFourier1GetValue(Sender: TObject; Index: LongInt;
  ComplexPart: TComplexNumPart; var Value: Double);
begin
  case RadioGroupInitData.ItemIndex of
    0: // Base
      if ComplexPart = cpRe then
        Value := 0.5 * sin(Index/16) + 0.4*sin(Index/4) + 0.1 * Randoms[1+(Index mod 8192)]
      else
        Value := 0;
    1: //     /\/\
      if ComplexPart = cpRe then
        if (Index mod 16)>7 then
          Value := (1 - (Index mod 16)/8)*0.9+0.1*Randoms[1+(Index mod 8192)]
        else
          Value := ((Index mod 16)/8-1)*0.9+0.1*Randoms[1+(Index mod 8192)]
      else
        Value := 0;
    2: //     _-_-_
      if ComplexPart = cpRe then
        if (Index mod 10)>4 then
          Value := -0.9+0.1*Randoms[1+(Index mod 8192)]
        else
          Value := 0.9+0.1*Randoms[1+(Index mod 8192)]
      else
        Value := 0;
    3: //   / / / /
      if ComplexPart = cpRe then
        Value := ((Index mod 10)/10-0.5)*0.9+0.1*Randoms[1+(Index mod 8192)]
      else
        Value := 0;
  end;
end;

end.
